/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.llc;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.util.Locale;

public class ActionLlc
implements StatusMapper,
TableStatusNamer {
    private static String bundleName = "ibm.nways.llc.Resources";
    private static String enumBundle = "ibm.nways.llc.eui.EnumeratedResources";
    private boolean loggingOn = false;

    public ActionLlc() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        try {
            Object[] objectArray = statusModelInfo.getIndexes();
            if (this.loggingOn) {
                System.out.println("ActionLlc");
                System.out.println("Interface = " + objectArray[0] + " Local SAP = " + objectArray[1] + " Remote SAP = " + objectArray[2] + " Remote MAC = " + objectArray[3] + " Local MAC = " + objectArray[4]);
                System.out.println("llcCcOperState = " + statusModelInfo.get("Panel.LlcCcOperState"));
            }
            String string = objectArray[3].toString();
            objectArray[3] = string;
            string = objectArray[4].toString();
            objectArray[4] = string;
            StatusAndExplain statusAndExplain = this.evaluateStatus((Integer)statusModelInfo.get("Panel.LlcCcOperState"), objectArray);
            statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        Object[] objectArray = statusModelInfo.getIndexes();
        String string = objectArray[3].toString();
        objectArray[3] = string;
        string = objectArray[4].toString();
        objectArray[4] = string;
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bundleName, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        I18NString i18NString = new I18NString(bundleName, "STATUS_TABLE_NAME");
        return i18NString;
    }

    private StatusAndExplain evaluateStatus(int n, Object[] objectArray) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = new I18NMsgFormat(bundleName, "SESSION", objectArray);
        switch (n) {
            case 1: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.llc.model.LlcCcOperModel.Panel.LlcCcOperState.discontacted");
                break;
            }
            case 2: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.llc.model.LlcCcOperModel.Panel.LlcCcOperState.contactPending");
                break;
            }
            case 3: {
                statusAndExplain.statType = StatusType.NORMAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.llc.model.LlcCcOperModel.Panel.LlcCcOperState.contacted");
                break;
            }
            case 4: {
                statusAndExplain.statType = StatusType.MARGINAL;
                objectArray2[1] = new I18NString(enumBundle, "ibm.nways.llc.model.LlcCcOperModel.Panel.LlcCcOperState.discontactPending");
                break;
            }
            default: {
                statusAndExplain.statType = StatusType.UNKNOWN;
                objectArray2[1] = new I18NString(bundleName, "UNEXPECTED");
            }
        }
        statusAndExplain.explain = new I18NGiblets(bundleName, "STATUSMESSAGE", objectArray2);
        if (this.loggingOn) {
            System.out.println("ret.statType = " + statusAndExplain.statType);
            System.out.println("ret.explain = " + statusAndExplain.explain.getTranslation(Locale.getDefault()));
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionLlc.this = ActionLlc.this;
        }
    }
}

